function StartBattle(battle, background, canlose)
{
	battle.reset();
	if (battle.boss_battle)
	{
		;// Play boss music
	}
	if (!battle.boss_battle)
	{
		//Battles.normal_music.play(true);
	}
	for (var i = 0; i < Game.psize; i ++)
	{
		Game.party[i].time = 0;
		Game.party[i].x = 248;
		Game.party[i].y = i * 40 + 70;
	}
	RenderMap();
	Swish(2, 4000);
	battle.background = background;
	Game.battleopen = true;
	Game.curBattle = battle;
	battle.draw();
	FadeIn(2000);
	battle.engine();
	if (battle.winner)
	{
		battle.draw();
		FadeOut(2000);
		battle.victory();
	}
	if (canlose)
	{
		return battle.winner;
	}
	if (!battle.winner && canlose == undefined)
	{
		battle.gameover();
	}
	RenderMap();
	FadeIn(1000);
}

function Battle(boss)
{
	this.boss_battle = boss;
	this.finished = false;
	this.winner;
	this.situation = "Time";
	this.enemy = new Array();
	this.exp = 0;
	this.money = 0;
	this.ap = 0;
	this.items = new Array();
	this.current = undefined;
	this.paused = false;
	this.damage = new Array();
	this.color = CreateColor(255, 255, 255);
}

Battle.prototype.addEnemy = function(enemy, x, y)
{
	this.enemy[this.enemy.length] = enemy.clone();
	this.enemy[this.enemy.length - 1].x = x;
	this.enemy[this.enemy.length - 1].y = y;
}

Battle.prototype.reset = function()
{
	this.finished = false;
	this.winnder = undefined;
	this.situation = "Time";
	this.exp = 0;
	this.money = 0;
	this.ap = 0;
	this.items = new Array();
	this.current = undefined;
	this.damage = new Array();
	for (var i = 0; i < this.enemy.length; i ++)
	{
		this.enemy[i].hp = this.enemy[i].maxhp;
		this.enemy[i].mp = this.enemy[i].maxmp;
		this.enemy[i].ailments = AilmentArray();
		this.enemy[i].situation = "Normal";
		this.enemy[i].time = 0;
	}
	this.color.alpha = 255;
}

Battle.prototype.engine = function()
{
	while (!this.finished)
	{
		this.draw();
		this.update();
		this.control();
		FlipScreen();
	}
}

Battle.prototype.draw = function(focus)
{
	Interrupt();
	this.background.blit(0, 0);
	var yMinus = GetCharacters() * 12;
	// Draw sprites
	for (var i = 0; i < Game.psize; i ++)
	{
		Game.party[i].drawSprite();
	}
	for (var i = 0; i < this.enemy.length; i ++)
	{
		this.enemy[i].drawSprite();
	}
	// Draw effects
	
	// Draw damage
	for (var i = 0; i < this.damage.length; i ++)
	{
		font.battleText(this.damage[i].target.x + this.damage[i].target.sprite.images[0].width / 2, this.damage[i].target.y + this.damage[i].target.sprite.images[0].height - 9 - (this.damage[i].time / 2), this.damage[i].amount + this.damage[i].type, "center", this.color);
		if (this.damage[i].time < 42)
		{
			this.damage[i].time ++;
		}
		if (this.damage[0].time == 42 && i == this.damage.length - 1)
		{
			this.damage = new Array();
			this.color.alpha = 255;
		}
	}
	if (this.damage.length > 0 && this.damage[0].time > 10)
	{
		this.color.alpha -= 8;
	}
	// Draw character stuff
	window.heading.drawWindow(144, 238 - yMinus, 170, 0);
	font.littleText(148, 231 - yMinus, "NAME");
	font.littleText(222, 231 - yMinus, "HP");
	font.littleText(248, 231 - yMinus, "MP");
	font.littleText(273, 231 - yMinus, "TIME");
	if (this.current != undefined)
	{
		GradientRectangle(144, 238 - yMinus + this.current * 12, 174, 14, Colors.YellowS, Colors.YellowS2, Colors.YellowS2, Colors.YellowS);
		Game.party[this.current].bMenu.draw(30, 180, 58, 4, focus);
	}
	for (var i = 0; i < Game.psize; i ++)
	{
		if (Game.party[i].available == true)
		{
			window.battleWindow(148, 240 - yMinus + i * 12, i);
		}
	}
	if (this.paused == true)
	{
		ApplyColorMask(Colors.Shadow);
		window.drawWindow(130, 100, 60, 5, true);
		font.drawText(139, 98, "PAUSED");
	}
}

Battle.prototype.update = function()
{
	if (this.paused == false)
	{
		var victor = this.testWin();
		if (victor == true)
		{
			this.finished = true;
			this.winner = true;
		}
		if (victor == false)
		{
			this.finished = true;
			this.winner = false;
		}
		if (this.situation == "Time")
		{
			// Update characters
			for (var i = 0; i < Game.psize; i ++)
			{
				if (IsAvailable(Game.party[i]))
				{
					Game.party[i].time += Game.party[i].speed;
					if (Game.party[i].time >= 1000)
					{
						Game.party[i].time = 1000;
						Game.party[i].turn = true;
						Game.party[i].curMenu = Game.party[i].bMenu;
						if (this.current == undefined)
						{
							this.current = i;
						}
					}
				}
			}
			// Update enemies
		}
	}
}

Battle.prototype.control = function()
{
	if (LastPush())
	{
		if (IsKeyPressed(Game.start))
		{
			Game.last_push = GetTime();
			if (this.paused == false)
			{
				this.paused = true;
			}
			else
			this.paused = false;
		}
		if (IsKeyPressed(Game.menu))
		{
			Game.last_push = GetTime();
			if (this.current != undefined)
			{
				this.nextCharacter();
			}
		}
	}
	if (this.current != undefined)
	{
		Game.party[this.current].bMenu.control();
	}
}

Battle.prototype.nextCharacter = function()
{
	Game.party[this.current].bMenu.reset();
	var t = undefined;
	for (var i = 0; t != undefined; i ++)
	{
		if (Game.party[this.current + 1 + i % Game.psize].turn == true)
		{
			t = i;
		}
	}
	this.current = t;
}

// Victory screen! :D
Battle.prototype.victory = function()
{
	var expGiving = true;
	var givenExp = 0;
	var givenMoney = 0;
	var moving = false;
	var moneyGiving = true;
	while (expGiving && moneyGiving)
	{
		Interrupt();
		DrawBG();
		window.tborder.drawWindow(16, 16, 150, 185);
		for (var i = 0; i < 4; i ++)
		{
			window.victoryWindow(16, 16 + i * 47, Game.party[i]);
		}
		font.littleText(20, 8, "CURRENT PARTY");
		window.drawWindow(183, 20, 117, 10, "Top", "INFO");
		font.drawText(183, 20, "Received EXP and AP");
		window.drawWindow(183, 51, 117, 44, true);
		font.drawText(183, 51, "Experience Points");
		font.drawText(300, 64, this.exp - givenExp, "right");
		font.drawText(183, 76, "Ability Points (AP)");
		font.drawText(300, 88, this.ap, "right");
		window.drawWindow(183, 119, 117, 10, "Top", "INFO");
		if (this.items.length > 0)
		{
			font.drawText(183, 119, "Found money & items");
			window.drawWindow(183, 150, 117, 20 + (this.items.length * 16), true, "FUNDS & ITEM(S)");
			for (var i = 0; i < this.items.length; i ++)
			{
				font.iconText(183, 174 + i * 14, this.items[i]);
				font.drawText(300, 176 + i * 14, "x" + this.items[i].amount, "right");
			}
		}
		else
		{
			font.drawText(183, 119, "Found money");
			window.drawWindow(183, 150, 117, 20, true, "FUNDS");
		}
		font.drawText(300, 150, Game.money + "$", "right");
		font.drawText(300, 162, this.money - givenMoney + "$", "right");
		FlipScreen();
		if (LastPush())
		{
			if (IsKeyPressed(Game.accept))
			{
				if (!moving && givenExp < this.exp && givenMoney < this.money)
				{
					KeyPressed();
					moving = true;
				}
				else if (moving && givenExp < this.exp && givenMoney < this.money)
				{
					KeyPressed();
					moving = false;
					for (var i = 0; i < Game.psize; i ++)
					{
						Game.party[i].giveExp(this.exp - givenExp);
					}
					givenExp = this.exp;
					Game.money += this.money - givenMoney;
					givenMoney = this.money;
				}
				else if (!moving && this.exp == givenExp && this.money == givenMoney)
				{
					KeyPressed(false);
					expGiving = false;
					moneyGiving = false;
				}
			}
		}
		if (moving && givenExp < this.exp)
		{
			for (var i = 0; i < Game.psize; i ++)
			{
				Game.party[i].giveExp(1);
			}
			givenExp ++;
		}
		if (moving && givenMoney < this.money)
		{
			Game.money ++;
			givenMoney ++;
		}
	}
}

Battle.prototype.gameover = function()
{
	this.draw();
	FadeOut(2000);
	ApplyColorMask(Colors.Black);
	Battles.gameover.blit(160 - Battles.gameover.width / 2, 120 - Battles.gameover.height / 2);
	FadeIn(2000);
	while (!IsKeyPressed(Game.accept))
	{
		Battles.gameover.blit(160 - Battles.gameover.width / 2, 120 - Battles.gameover.height / 2);
		FlipScreen();
	}
	Battles.gameover.blit(160 - Battles.gameover.width / 2, 120 - Battles.gameover.height / 2);
	FadeOut(2000);
	Exit();
}

Battle.prototype.testWin = function()
{
	var enDead = 0;
	for (var i = 0; i < this.enemy.length; i ++)
	{
		if (this.enemy[i].hp == 0)
		{
			enDead ++;
		}
	}
	if (enDead == this.enemy.length)
	{
		return true;
	}
	var plDead = 0;
	for (var i = 0; i < Game.psize; i ++)
	{
		if (Game.party[i].hp == 0)
		{
			plDead ++;
		}
	}
	if (plDead == Game.psize)
	{
		return false;
	}
	return undefined;
}

function GiveDamage(target, amount, type)
{
	switch (type)
	{
		case "MP":
			target.mp -= amount;
			var damage = new Object();
			damage.target = target;
			damage.amount = amount;
			damage.type = "MP";
			damage.time = 0;
			Game.curBattle.damage[Game.curBattle.damage.length] = damage;
			if (target.mp < 0)
			{
				target.mp = 0;
			}
			break;
		default:
			target.hp -= amount;
			var damage = new Object();
			damage.target = target;
			damage.amount = amount;
			damage.type = "";
			damage.time = 0;
			Game.curBattle.damage[Game.curBattle.damage.length] = damage;
			if (target.hp < 0)
			{
				target.hp = 0;
				target.time = 0;
				target.die();
			}
			break;
	}
}

// Ends turn
function EndTurn(coe) // Character or enemy
{
	coe.turn = false;
	coe.time = 0;
	coe.situation = "Normal";
	if (Game.party[Game.curBattle.current] == coe)
	{
		Game.curBattle.current = undefined;
	}
	// Check for damaging ailments
	if (coe.ailments["Poison"] == true)
	{
		GiveDamage(coe, coe.hpmax * 0.05);
	}
}

function AvailableCharacters()
{
	var num = new Array();
	for (var i = 0; i < Game.psize; i ++)
	{
		if (Game.party[i].hp > 0)
		{
			num[num.length] = i;
		}
	}
	return num;
}

function AvailableEnemies()
{
	var num = new Array();
	for (var i = 0; i < Game.curBattle.enemy.length; i ++)
	{
		if (Game.curBattle.enemy[i].hp > 0)
		{
			num[num.length] = i;
		}
	}
	return num;
}

function IsAvailable(character)
{
	if (character.hp > 0 && character.available == true)
	{
		return true;
	}
	else
		return false;
}

function GetCharacters()
{
	var num = 0;
	for (var i = 0; i < Game.psize; i ++)
	{
		if (Game.party[i].available == true)
		{
			num ++;
		}
	}
	return num;
}

var Battles = new Object();
Battles.gameover = LoadImage("Game Over.png");
// Music
Battles.normal_music = LoadSound("Battle.it");
// Backgrounds
Battles.Plains = LoadImage("Plains-BG.png");
// Battle objects
Battles.Test1 = new Battle(false);
//Battles.Test1.addEnemy(Enemies.Shitake, 56, 87);
//Battles.Test1.addEnemy(Enemies.Jude, 23, 76);
Battles.Test1.addEnemy(Enemies.Jude, 23, 104);